# Rule 8.16 The alignment specification of zero should not appear in an object declaration

## Category

Advisory

## Analysis

Decidable, Single Translation Unit

## Applies to

C11

## Amplification

This rule applies to any integer constant expression operand to `Alignas` that evaluates to zero. 

## Rationale

If the alignment of an object is important, it should be specified explicitly. If configuration settings or platform implementation details are intended to change the alignment of an object to conditionally disable explicit alignment, this should be abstracted by the preprocessor. 

## Example

```c
int32_t a; /* Compliant: no alignment specification */
alignas (16) int32_t b; /* Compliant: explicit non-zero alignment specification */
alignas (0) int32_t c; /* Non-compliant: zero-alignment specification */
/* Non-compliant on platforms where sizeof (int) == sizeof (long) */
alignas (sizeof (long) - sizeof (int)) int32_t d;

```

When the alignment is not important, the configuration can remove it entirely:

```c
#if REQUIRED_ALIGNMENT > 0
#define ALIGNED alignas (REQUIRED_ALIGNMENT)
#else
#define ALIGNED /**/
#endif

```

## See also

Rule 8.15, Rule 8.17

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
