# Rule 9.3 Arrays shall not be partially initialized

## Category

Required

## Analysis

Decidable, Single Translation Unit

## Applies to

C90, C99, C11

## Amplification

If any element of an array object or subobject is explicitly initialized, then the entire object or subobject shall be explicitly initialized. 

## Rationale

Providing an explicit initialization for each element of an array makes it clear that every element has been considered. 

## Exception
1. An initializer of the form `{ 0 }` may be used to explicitly initialize all elements of an array object or subobject.
2. An array whose initializer consists only of designated initializers may be used, for example to perform a sparse initialization.
3. An array initialized using a string literal does not need an initializer for every element. 

## Example

```c
/* Compliant */
int32_t x[ 3 ] = { 0, 1, 2 };

/* Non-compliant - y[ 2 ] is implicitly initialized */
int32_t y[ 3 ] = { 0, 1 };

/* Non-compliant - t[ 0 ] and t[ 3 ] are implicitly initialized */
float32_t t[ 4 ] = { [ 1 ] = 1.0f, 2.0f };

/* Compliant - designated initializers for sparse matrix */
float32_t z[ 50 ] = { [ 1 ] = 1.0f, [ 25 ] = 2.0f };

```

In the following compliant example, each element of the array `arr` is initialized:

```c
float32_t arr[ 3 ][ 2 ] =
{
    { 0.0f, 0.0f },
    { PI / 4.0f, -PI / 4.0f },
    { 0 } /* initializes all elements of array subobject arr[ 2 ] */
};

```

In the following example, array elements 6 to 9 are implicitly initialized to `'\0'`:

```c
char h[ 10 ] = "Hello"; /* Compliant by Exception 3 */

```

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
