# Dir 4.11 The validity of values passed to library functions shall be checked 

## Category

Required 

## Applies to

C90, C99, C11 

## Amplification

The nature and organization of the project will determine which libraries, and functions within those libraries, should be subject to this directive. 

## Rationale

Many functions in the Standard Library are not required by the C Standard to check the validity of parameters passed to them. Even where checking is required by the C Standard, or where compiler writers claim to check parameters, there is no guarantee that adequate checking will take place. Similarly, the interface description for functions in other libraries may not specify the checks performed by those functions. There is also a risk that the specified checks are not performed adequately. 

The programmer shall provide appropriate checks of input values for all library functions which have a restricted input domain (the Standard Library, third-party libraries, and in-house libraries). 

Examples of functions from the Standard Library that have a restricted domain and need checking are: 
* Many of the maths functions in `<math.h>`, for example: 
* Negative numbers must not be passed to the sqrt or log functions; 
* The second parameter of fmod should not be zero; 
* Some implementations can produce unexpected results when the function toupper is passed an argument which is not a lowercase letter (and similarly for tolower); 
* The character testing functions in `<ctype.h>` exhibit undefined behaviour if passed invalid values; 
* The abs function applied to the most negative integer gives undefined behaviour. 

Although most of the math library functions in `<math.h>` define allowed input domains, the values they return when a domain error occurs may vary from one compiler to another. Therefore pre-checking the validity of the input values is particularly important for these functions. 

The trigonometric periodic functions in `<math.h>` incur significant precision loss when called with arguments with relatively large absolute value. If x is an IEC 60559 single-precision number and x >= 2^23, then the smallest single-precision range containing [x, x + 2*PI) contains no more than three floating-point numbers (the same holds for IEC 60559 [35] double-precision numbers substituting 2^52 to 2^23). This implies that computing trigonometric periodic functions on large values, because of the gross input inaccuracy, gives non-significant results independently from the quality of the function implementation. For this reason, trigonometric periodic functions should not be called on arguments whose absolute value is larger than k*PI, where k is a property of the floating-point representation. Ideally, this principle should be applied with k = 1, but depending on the application and its precision goals, a larger value for k can be used. 

The programmer should identify any domain constraints which should sensibly apply to a function being used (which may or may not be documented in the interface description), and provide appropriate checks that the input value(s) lies within this domain. Of course the value may be restricted further, if required, by knowledge of what the parameter represents and what constitutes a sensible range of values for the parameter. 

There are a number of ways in which the requirements of this guideline might be satisfied, including the following: 
* Check the values before calling the function; 
* Check the values in the called library function - this is particularly applicable for in-house designed libraries, though it could apply to bought-in libraries if the supplier can demonstrate that they have built in the checks; 
* Produce "wrapped" versions of functions that perform the checks then call the original function; 
* Demonstrate statically that the input parameters can never take invalid values. 

## See also

Dir 4.1, Dir 4.7 

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
