# Rule 15.2 The *goto* statement shall jump to a label declared later in the same function

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99, C11

## Rationale
Unconstrained use of *goto* can lead to programs that are unstructured and extremely difficult to understand.

Restricting the use of *goto* so that “back” jumps are prohibited ensures that iteration only occurs if the iteration statements provided by the language are used, helping to minimize visual code complexity.

## Example
```c
void f ( void )
{
  int32_t j = 0;

L1:
  ++j;

  if ( 10 == j )
  {
    goto L2;          /* Compliant     */
  }

  goto L1;            /* Non-compliant */

L2:
  ++j;
}
```

## See also
Rule 15.1, Rule 15.3, Rule 15.4

---

Copyright The MISRA Consortium Limited © [Date - March 2025].