# Rule 15.7 All *if … else if* constructs shall be terminated with an *else* statement

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99, C11

## Amplification
A final *else* statement shall always be provided whenever an *if* statement is followed by a sequence of one or more *else if* constructs. The *else* statement shall contain at least either one *side effect* or a comment.

A function call is considered to be a *side effect* for the purposes of this rule.

## Rationale
Terminating a sequence of *if … else if* constructs with an *else* statement is defensive programming and complements the requirement for a *default* clause in a *switch* statement (see Rule 16.5).

The *else* statement is required to have a *side effect* or a comment to ensure that a positive indication is given of the desired behaviour, aiding the code review process.

*Note:* a final *else* statement is not required for a simple *if* statement.

## Example
The following example is non-compliant as there is no explicit indication that no action is to be taken by the terminating *else*.
```c
if ( flag_1 )
{
  action_1 ( );
}
else if ( flag_2 )
{
  action_2 ( );
}
/* Non-compliant */
```
The following shows a compliant terminating *else*.
```c
else
{
  ; /* No action required - ; is optional */
}
```

## See also
Rule 16.4

---

Copyright The MISRA Consortium Limited © [Date - March 2025].