# Rule 18.3 The relational operators >, >=, < and <= shall not be applied to expressions of pointer type except where they point into the same object

## Category
Required

## Analysis
Undecidable, System

## Applies to
C90, C99, C11

## Rationale
Attempting to make comparisons between pointers will produce undefined behaviour if the two pointers do not point to the same object.

*Note:* it is permissible to address the next element beyond the end of an array, but accessing this element is not allowed.

## Example
```c
void f1 ( void )
{
  int32_t a1[ 10 ];
  int32_t a2[ 10 ];
  int32_t *p1 = a1;

  if ( p1 < a1 ) /* Compliant     */
  {
  }

  if ( p1 < a2 ) /* Non-compliant */
  {
  }
}

struct limits
{
  int32_t lwb;
  int32_t upb;
};

void f2 ( void )
{
  struct limits limits_1 = { 2, 5 };
  struct limits limits_2 = { 10, 5 };

  if ( &limits_1.lwb <= &limits_1.upb ) /* Compliant */
  {
  }

  if ( &limits_1.lwb > &limits_2.upb ) /* Non-Compliant */
  {
  }
}
```

## See also
Dir 4.1

---

Copyright The MISRA Consortium Limited © [Date - March 2025].