# Rule 21.12 The standard *header file* `<fenv.h>` shall not be used

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C99, C11

## Amplification
The standard *header file* `<fenv.h>` shall not be *#include*‘d, and none of the features that are specified as being provided by `<fenv.h>` shall be used.

## Rationale
In some circumstances, the values of the floating-point status flags are unspecified and attempts to access them may lead to undefined behaviour.

The order in which exceptions are raised by the *feraiseexcept* function is unspecified and could therefore result in a program that has been designed for a certain order not operating correctly.

Calling the *fesetenv* or *feupdateenv* functions with invalid arguments results in undefined behaviour.

Calling the *fesetround* function should be done with care because:
1.  Setting the rounding mode may have unexpected consequences, e.g. setting the current rounding mode to upwards does not guarantee that the result of evaluating an expression is an upward approximation to the value of the expression over the reals.
2.  Several implementations of functions declared in `<math.h>` have been designed to support round-to-nearest only: if such functions are called when a different rounding mode is set, the results can be unpredictable.

*Note:* In conforming implementations, the rounding direction mode is set to rounding to nearest at program start-up.

## Example
```c
#include <fenv.h> /* Non-compliant #include */

void f ( float x, float y )
{
  float z;

  feclearexcept ( FE_DIVBYZERO ); /* Non-compliant */

  z = x / y;

  if ( fetestexcept ( FE_DIVBYZERO ) ) /* Non-compliant */
  {
  }
  else
  {
#pragma STDC FENV_ACCESS ON
    z = x * y;
  }

  if ( z > x )
  {
#pragma STDC FENV_ACCESS OFF
    if ( fetestexcept ( FE_OVERFLOW ) ) /* Non-compliant */
    {
    }
  }
}
```

---

Copyright The MISRA Consortium Limited © [Date - March 2025].