# Rule 22.2 A block of memory shall only be freed if it was allocated by means of a Standard Library function

## Category
Mandatory

## Analysis
Undecidable, System

## Applies to
C90, C99, C11

## Amplification
The Standard Library functions that allocate memory are *malloc*, *calloc* and *realloc*.

A block of memory is freed when its address is passed to *free* and potentially freed when its address is passed to *realloc*. Once freed, a block of memory is no longer considered to be allocated and therefore cannot subsequently be freed again.

## Rationale
Freeing non-allocated memory, or freeing the same allocated memory more than once leads to undefined behaviour.

## Example
```c
#include <stdlib.h>

void fn ( void )
{
  int32_t a;

  /* Non-compliant - a does not point to allocated storage */
  free ( &a );
}

void g ( void )
{
  char *p = ( char * ) malloc ( 512 );
  char *q = p;

  free ( p );

  /* Non-compliant - allocated block freed a second time */
  free ( q );

  /* Non-compliant - allocated block may be freed a third time */
  p = ( char * ) realloc ( p, 1024 );
}
```

## See also
Dir 4.12, Dir 4.13, Rule 21.3

---

Copyright The MISRA Consortium Limited © [Date - March 2025].