# Rule 22.4 There shall be no attempt to write to a stream which has been opened as read-only

## Category
Mandatory

## Analysis
Undecidable, System

## Applies to
C90, C99, C11

## Rationale
The C Standard does not specify the behaviour if an attempt is made to write to a read-only stream. For this reason it is considered unsafe to write to a read-only stream.

## Example
```c
#include <stdio.h>

void fn ( void )
{
  FILE *fp = fopen ( "tmp", "r" );

  ( void ) fprintf ( fp, "What happens now?" ); /* Non-compliant */

  ( void ) fclose ( fp );
}
```

## See also
Rule 21.6

---

Copyright The MISRA Consortium Limited © [Date - March 2025].