# Rule 8.6 An identifier with external linkage shall have exactly one external definition

## Category
Required

## Analysis
Decidable, System

## Applies to
C90, C99, C11

## Rationale
The behaviour is undefined if an identifier is used for which multiple definitions exist (in different files) or no definition exists at all. Multiple definitions in different files are not permitted by this rule even if the definitions are the same.

## Example
In this example the object `i` is defined twice:

```c
/* file1.c */
int16_t i = 10;

/* file2.c */
int16_t i = 20;     /* Non-compliant - two definitions of i */
```

In this example the object `j` has one tentative definition and one external definition:

```c
/* file3.c */
int16_t j;          /* Tentative definition */
int16_t j = 1;      /* Compliant - external definition */
```

The following example is non-compliant because the object `k` has two external definitions. The tentative definition in `file4.c` becomes an external definition at the end of the translation unit:

```c
/* file4.c */
int16_t k;          /* Tentative definition - becomes external */

/* file5.c */
int16_t k = 0;      /* External definition */
```

## See also
Rule 8.15

---

Copyright The MISRA Consortium Limited © [Date - March 2025].