# Rule 14–5–1 (Required) A non-member generic function shall only be declared in a namespace that is not an associated namespace.

## Rationale
Argument-dependent lookup (ADL) adds additional associated namespaces to the set of scopes searched when lookup is performed for the names of called functions. A generic function found in one of these additional namespaces would be added to the overload set and chosen by overload resolution, which is inconsistent with developer expectation.

## Example
```c
template <typename T> 
class B 
{ 
public: 
 B operator+ ( long & rhs );
 void f ( ) 
 { 
 *this + 10; // calls NS::operator+ and not 
 // B<NS::A>::operator+ when B is 
 // instantiated with NS::A 
 } 
};
namespace NS 
{ 
 class A { 
 public: 
 };
 template <typename T> 
 bool operator+ ( T, int32_t ); // Non-compliant – within associated 
 // namespace 
}
template class B<NS::A>;
```
ADL considers the namespace NS to be an associated namespace. There are three functions in the overload set:
* The built-in operator+
 T operator+ ( T, T );
* The member operator+
 B<NS::A> B<NS::A>::operator+ ( long );
* The specialized generic function
 bool NS::operator+< B<NS::A> > ( B<NS::A>, int32_t )

The conversion from the literal 10 to int32_t is a better match than that to long, and therefore NS::operator+ is chosen rather than the member operator+, which may be inconsistent with developer expectations.

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
