# Rule 14–6–2 (Required) The function chosen by overload resolution shall resolve to a function declared previously in the translation unit.

## Rationale
Argument-dependent lookup (ADL) adds additional associated namespaces to the set of scopes searched when lookup is performed for the names of called functions. For function templates, ADL is performed at the point of instantiation of the function template, and so it is possible that a function declared after the template may be called.
To ensure that ADL does not take place when calling a function with a dependent argument, the postfix-expression denoting the called function can either be a qualified name or a parenthesized expression.

## Example
```c
void b ( int32_t );
template <typename T> 
void f ( T const & t ) 
{ 
 b ( t ); // Non-compliant - Calls NS::b declared after f 
 ::b ( t ); // Compliant - Calls ::b 
 ( b ) ( t ); // Compliant - Calls ::b 
}
namespace NS 
{ 
 struct A 
 { 
 operator int32_t ( ) const; 
 };
 void b ( A const & a ); 
}
int main ( ) 
{ 
 NS::A a;
 f ( a ); 
}
```
Operators with dependent types may also have this problem. In order to avoid ADL in these examples, operators should not be overloaded, or the calls should be changed to use explicit function call syntax and a qualified name or parenthesized expression used, as above.
For example:
```c
template <typename T>
void f ( T const & t )
{ 
 t == t; // Non-compliant - Calls NS::operator==
 // declared after f
 ::operator ==( t, t ); // Compliant - Calls built-in operator==
 ( operator == <T> ) ( t, t ); // Compliant - Calls built-in operator==
}
namespace NS 
{ 
 struct A 
 { 
 operator int32_t ( ) const; 
 };
 bool operator== ( A const &, A const & ); 
}
int main ( ) 
{ 
 NS::A a; 
 f ( a ); 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
