# Rule 14–7–3 (Required) All partial and explicit specializations for a template shall be declared in the same file as the declaration of their primary template.

## Amplification
[NDR 14.5.4(1), 14.6.4.1(7), 14.7.3(6)]

## Rationale
It is undefined behaviour if, for a set of template-arguments, an implicit instantiation is generated by the compiler, and a partial or explicit specialization is declared or defined elsewhere in the program that would match the set of template-arguments.

## Example
```c
// tmpl.h 
template <typename T> void bad_tmpl () {}
template <typename T> void good_tmpl () {} 
template <> void good_tmpl<int32_t> () {}
// tmpl.cc 
#include "tmpl.h" 
template <> void bad_tmpl<int32_t> () {} // Non-compliant 
template <> void good_tmpl<int32_t> () {}
// f.cc 
#include <tmpl.h>
void f () 
{ 
 bad_tmpl<int32_t> (); // implicit instantiation of primary. 
 // explicit instantiation in tmpl.cc would 
 // have been used if it were visible. 
 good_tmpl<int32_t> (); // specialization of good_tmpl<int32_t> is 
 // visible with the primary declaration. 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
