# Rule 15–0–2 (Advisory) An exception object should not have pointer type.

## Rationale
If an exception object of pointer type is thrown and that pointer refers to a dynamically created object, then it may be unclear which function is responsible for destroying it, and when. This ambiguity does not exist if the object is caught by value or reference.

## Example
```c
class A 
{ 
 // Implementation 
};
void fn ( int16_t i ) 
{ 
 static A a1; 
 A * a2 = new A;
 if ( i > 10 ) 
 { 
 throw ( &a1 ); // Non-compliant – pointer type thrown 
 }
 else 
 { 
 throw ( a2 ); // Non-compliant – pointer type thrown 
 } 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
