# Rule 16–0–5 (Required) Arguments to a function-like macro shall not contain tokens that look like preprocessing directives.

## Amplification
[Undefined 16.3(10)]

## Rationale
If any of the arguments act like preprocessor directives, the behaviour when macro substitution is made can be unpredictable.

## Example
```c
#define M(A) printf ( #A )
void main ( ) 
{ 
 M( 
#ifdef SW // Non-compliant 
 "Message 1" 
#else // Non-compliant 
 "Message 2" 
#endif // Non-compliant 
 ); 
}
```
The above may print
```c
#ifdef SW "Message 1" #else "Message 2" #endif
```
or
```c
Message 2
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
