# Rule 16–0–8 (Required) If the # token appears as the first token on a line, then it shall be immediately followed by a preprocessing token.

## Rationale
When a section of source code is excluded by preprocessor directives, the content of each excluded statement is ignored until a #else, #elif or #endif directive is encountered (depending on the context). If one of these excluded directives is badly formed, it may be ignored without warning by a compiler with unexpected consequences.
The requirement of this rule is that all preprocessor directives shall be syntactically valid even when they occur within an excluded block of code.
In particular, ensure that #else and #endif directives are not followed by any characters other than white-space. Compilers are not always consistent in enforcing this requirement.

## Example
```c
#define AAA 2
int32_t foo(void) 
{ 
 int32_t x = 0; 
 ... 
#ifndef AAA 
 x = 1; 
#else1 // Non-compliant 
 x = AAA; 
#endif 
 ... 
 return x; 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
