# Rule 16–2–3 (Required) Include guards shall be provided.

## Amplification
The include guard shall use one of the following two forms:
```c
<start-of-file> 
// Comments allowed here 
#if !defined ( identifier ) 
#define identifier 
 // Contents of file 
#endif 
<end-of-file>
<start-of-file> 
// Comments allowed here 
#ifndef identifier 
#define identifier 
 // Contents of file 
#endif 
<end-of-file>
```

## Rationale
When a translation unit contains a complex hierarchy of nested header files, it is possible for a particular header file to be included more than once. This can be, at best, a source of confusion. If this multiple inclusion leads to multiple or conflicting definitions, then this can result in undefined or erroneous behaviour.
These forms are mandated to facilitate checking.

## Example
```c
// file.h 
#ifndef FILE_H
#endif
// file.cc 
#include "file.h" 
#define FILE_H // Non-compliant
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
