# Rule 2–10–2 (Required) Identifiers declared in an inner scope shall not hide an identifier declared in an outer scope.

## Rationale
If an identifier is declared in an inner scope and it uses the same name as an identifier that already exists in an outer scope, then the innermost declaration will “hide” the outer one. This may lead to developer confusion.
The terms outer and inner scope are defined as follows:
* Identifiers that have file scope can be considered as having the outermost scope.
* Identifiers that have block scope have a more inner scope.
* Successive, nested blocks, introduce more inner scopes.

## Example
```c
int16_t i; 
{ 
 int16_t i; // This is a different variable 
 // This is Non-compliant 
 i = 3; // It could be confusing as to which i this refers 
}
void fn ( int16_t i ) // Non-compliant 
{
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
