# Rule 2–5–1 (Advisory) Digraphs should not be used.

## Rationale
The digraphs are:
`<% %> <: :> %: %:%:`
The use of digraphs may not meet developer expectations.

## Example
```c
template < typename T> 
class A 
{ 
 public: 
 template < int32_t i > 
 void f2 ( ); 
};
void f ( A<int32_t> * a<:10:> ) // Non-compliant 
<% a<:0:>->f2<20> ( ); %> // Non-compliant
// The above is equivalent to: 
void f ( A<int32_t> * a[ 10 ] ) 
{ 
 a[ 0 ]->f2<20> ( ); // Compliant 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
