# Rule 3–9–2 (Advisory) typedefs that indicate size and signedness should be used in place of the basic numerical types.

## Amplification
[Implementation 3.9.1(1, 5)]

## Rationale
The basic numerical types of char, int, short, long, float, double and long double should not be used, but specific-length typedefs should be used. This rule helps to clarify the size of the storage, but does not guarantee portability because of the asymmetric behaviour of integral promotion. See the discussion of integral promotion in Section 6.5.0. It is still important to understand the integer size of the implementation.
Developers should be aware of the actual implementation of the typedefs under these definitions.

## Exception
The wchar_t does not need a typedef as it always maps to a type that supports wide characters.
The char_t typedef does not indicate size and signedness and is simply included to allow char objects to be declared without the use of the basic char type, allowing any use of (plain) char to be detected and reported by analysis tools.

## Example
The ISO (POSIX) typedefs as shown below are recommended and are used for all basic numerical and character types in this document. For a 32-bit integer machine, these are as follows:
```c
typedef char char_t; 
typedef signed char int8_t; 
typedef signed short int16_t; 
typedef signed int int32_t; 
typedef signed long int64_t; 
typedef unsigned char uint8_t; 
typedef unsigned short uint16_t; 
typedef unsigned int uint32_t; 
typedef unsigned long uint64_t; 
typedef float float32_t; 
typedef double float64_t; 
typedef long double float128_t;
```
typedefs are not considered necessary in the specification of bit-field types.

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
