# Rule 5–2–4 (Required) C-style casts (other than void casts) and functional notation casts (other than explicit constructor calls) shall not be used.

## Rationale
C-style (cast notation), and functional notation casts that do not invoke a converting constructor are capable of performing casts between unrelated types.

## Exception
A C-style cast to void may be used to signify that the return value for a non-void function call is being ignored (see Rule 0–1–7).

## Example
```c
class A 
{ 
public: 
 explicit A( int32_t ); 
};
int32_t g ( ) 
{
 return 7; 
}
void f ( ) 
{ 
 A const a1 = A( 10 ); // Compliant 
 A * a2 = ( A* )( &a1 ); // Non-compliant 
 A * a3 = const_cast<A*>( &a1 ); // Compliant, but breaks Rule 5–2–5 
 (void)g ( ); // Compliant by exception 
}
```
In the above example, the C-style cast from a1 to a non-const pointer is stronger than necessary. If the type of a1 is changed at some future date, then the cast may continue to compile.

## See also
ISO/IEC 14882:2003 [1] §5.2.3, §5.4

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
