# Rule 6–5–4 (Required) The loop-counter shall be modified by one of: --, ++, -=n, or +=n; where n remains constant for the duration of the loop.

## Rationale
This helps to ensure deterministic loop termination. The other for loop rules mean that the modification can only take place within expression.

## Example
```c
for ( x = 0; x < 10; ++x ) // Compliant 
for ( T x = thing.start( ); 
 x != thing.end( ); 
 ++x ) // Compliant 
for ( x = 0; x < 10; x += 1 ) // Compliant 
for ( x = 0; x < 10; x += n ) // Compliant if n is not modified 
 // within the body of the loop. 
for ( x = 0; x < 10; x += fn ( ) ) // Non-compliant
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
