# Rule 6–6–1 (Required) Any label referenced by a goto statement shall be declared in the same block, or in a block enclosing the goto statement.

## Rationale
Unconstrained use of goto can lead to programs that are extremely difficult to comprehend, analyse and, for C++, can also lead to the program exhibiting unspecified behaviour.
However, in many cases a total ban on goto requires the introduction of flags to ensure correct control flow, and it is possible that these flags may themselves be less transparent than the goto they replace.
Therefore, the restricted use of goto is allowed where that use will not lead to semantics contrary to developer expectations. Jumping in to nested blocks is prohibited as it may lead to complex flow graphs.

## Example
```c
void f1 ( ) 
{ 
 int32_t j = 0;
 goto L1; 
 for ( j = 0; j < 10 ; ++j ) 
 { 
L1: // Non-compliant 
 j; 
 } 
}
void f2 ( ) 
{ 
 for ( int32_t j = 0; j < 10 ; ++j ) 
 { 
 for ( int32_t i = 0; i < 10; ++i ) 
 { 
 goto L1; 
 } 
 } 
L1: // Compliant 
 f1 ( ); 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
