# Rule 6–6–2 (Required) The goto statement shall jump to a label declared later in the same function body.

## Rationale
Unconstrained use of goto can lead to programs that are extremely difficult to comprehend, analyse and, for C++, can also lead to the program exhibiting unspecified behaviour.
However, in many cases a total ban on goto requires the introduction of flags to ensure correct control flow, and it is possible that these flags may themselves be less transparent than the goto they replace.
Therefore, the restricted use of goto is allowed where that use will not lead to semantics contrary to developer expectations. “Back” jumps are prohibited as they can be used to create iterations without using the well-defined iteration statements supplied by the core language.

## Example
```c
void f ( ) 
{ 
 int32_t j = 0;
L1: 
 ++j; 
 if ( 10 == j ) 
 { 
 goto L2; // Compliant 
 } 
 goto L1; // Non-compliant 
L2: 
 ++j; 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
