# Rule 8–3–1 (Required) Parameters in an overriding virtual function shall either use the same default arguments as the function they override, or else shall not specify any default arguments.

## Rationale
Default arguments are determined by the static type of the object. If a default argument is different for a parameter in an overriding function, the value used in the call will be different when calls are made via the base or derived object, which may be contrary to developer expectations.

## Example
```c
class Base 
{ 
public: 
 virtual void g1 ( int32_t a = 0 ); 
 virtual void g2 ( int32_t a = 0 ); 
 virtual void b1 ( int32_t a = 0 ); 
};
class Derived : public Base 
{ 
public:
 virtual void g1 ( int32_t a = 0 ); // Compliant - same default used 
 virtual void g2 ( int32_t a ); // Compliant - 
 // no default specified 
 virtual void b1 ( int32_t a = 10 ); // Non-compliant - different 
value 
};
void f( Derived& d ) 
{ 
 Base& b = d;
 b.g1 ( ); // Will use default of 0 
 d.g1 ( ); // Will use default of 0 
 b.g2 ( ); // Will use default of 0 
 d.g2 ( 0 ); // No default value available to use 
 b.b1 ( ); // Will use default of 0 
 d.b1 ( ); // Will use default of 10 
}
```
The default argument for g2 can only be used via the base class object and so the value used will always be the same.

## See also
ISO/IEC 14882:2003 [1] §8.3.6(10)

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
