# Rule 8–5–2 (Required) Braces shall be used to indicate and match the structure in the non-zero initialization of arrays and structures.

## Rationale
ISO/IEC 14882:2003 [1] requires initializer lists for arrays, structures and union types to be enclosed in a single pair of braces (though the behaviour if this is not done is undefined). The rule given here goes further in requiring the use of additional braces to indicate nested structures. This forces the developer to explicitly consider and demonstrate the order in which elements of complex data types are initialized (e.g. multi-dimensional arrays).
The zero initialization of arrays or structures shall only be applied at the top level.
The non-zero initialization of arrays or structures requires an explicit initializer for each element.

## Example
The following shows two valid ways of initializing the elements of a two dimensional array, but the first does not adhere to the rule:
```c
int16_t y[3][2] = { 1, 2, 3, 4, 5, 6 }; // Non-compliant 
int16_t y[3][2] = { { 1, 2 }, { 3, 4 }, { 5, 6 } }; // Compliant
```
A similar principle applies to structures, and nested combinations of structures, arrays and other types.
Note also that all the elements of arrays or structures can be initialized (to zero or NULL) by giving an explicit initializer for the first element only. If this method of initialization is chosen then the first element should be initialized to zero (or NULL), and nested braces need not be used.
```c
// The following are compliant 
int16_t a1[5] = { 1, 2, 3, 0, 0 }; // Non-zero initialization 
int16_t a2[5] = { 0 }; // Zero initialization 
int16_t a3[2][2] = { }; // Zero initialization
// The following are non-compliant 
int16_t a4[5] = { 1, 2, 3 }; // Partial initialization 
int16_t a5[2][2] = { { }, { 1, 2 } }; // Zero initialization 
 // at sub-level
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
