# Rule 10.3.1 There should be no unnamed namespaces in header files

## Category
Advisory

## Analysis
Decidable, Single Translation Unit

## Rationale
An unnamed namespace is unique within each *translation unit*. Any *declarations* appearing in an
unnamed namespace within a *header file* refer to different *entities* in each *translation unit*, which might
not be consistent with developer expectations.

## Example
```cpp
// Header.hpp
namespace // Non-compliant
{
 inline int32_t x;
}

void fn_a();

// File1.cpp
#include "Header.hpp"

void fn_a()
{
 x = 42;
}

// File2.cpp
#include "Header.hpp"

void fn_b()
{
 fn_a(); // Assigns 42 to 'x' in translation unit for 'File1.cpp'
 if ( x == 42 ) {} // 'x' within this translation unit will not have the value 42
}
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
