# Rule 11.6.3 Within an enumerator list, the value of an implicitly-specified enumeration constant shall be unique

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Rationale
An implicitly-specified *enumeration constant* has a value one greater than its predecessor. If the first
*enumeration constant* is implicitly-specified, then its value is zero.

An explicitly-specified *enumeration constant* has the value of the associated *constant expression*.

If implicitly-specified and explicitly-specified constants are mixed within an enumeration list, it is
possible for values to be duplicated. Such duplication may be unintentional and may give rise to
unexpected behaviour.

This rule requires that any duplication of *enumeration constants* be made explicit, thus making the
intent clear.

## Exception
An implicitly-specified *enumeration constant* may have the same value as an explicitly-specified
*enumeration constant* from the same enumeration when the explicitly-specified value is defined using
only the name of another *enumeration constant*.

## Example
The following examples are compliant as it is clear which *enumeration constants* have the same value:

```cpp
enum E1 { A = 3, B, C = 5, D = 5 }; // Compliant
enum E2 { A = 3, B, C, D = C, E = D }; // Compliant by exception
```

The following examples are non-compliant as *enumeration constants* have the same implicit values:

```cpp
enum E3 { A = 3, B, C, D = 4 }; // 'B' and 'D' have the same value
enum E4 { A = 3, B, C, D = B, E }; // 'C' and 'E' have the same value
```

The following example is non-compliant as the use of `B + 1` means the exception does not apply.

```cpp
enum E5 { A = 3, B, C, D = B + 1 }; // Non-compliant
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
