# Rule 17.8.1 Function templates shall not be explicitly specialized

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Amplification
This rule also applies to member function templates, but not non-template member functions of class
templates.

## Rationale
Explicit function specializations will be considered only after overload resolution has chosen a best
match from the set of primary function templates. Furthermore, when the overload set contains both
template and non-template versions that are otherwise an equal match for overload resolution, the
template version (and therefore its specializations) will not be selected. All of this may be inconsistent
with developer expectations.

*Note:* overloads provide a better solution than the use of explicit function specializations.

## Example
```cpp
template< typename T > void f1( T ); // Overload # 1A
template<> void f1< char * >( char * ); // Non-compliant - explicit
 // specialization of overload # 1A
template< typename T > void f1( T * ); // Overload # 1B

template< typename T > void f2( T ); // Overload # 2A
template< typename T > void f2( T * ); // Overload # 2B
void f2( char * ); // Overload # 2C - rule does not apply

template< typename T > void f3( T );
template<> void f3< char * >( char * ); // Non-compliant - explicit
 // specialization of f3

void b( char * s )
{
 f1( s ); // Calls overload # 1B, with T = char
 f2( s ); // Calls overload # 2C
}
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
