# Rule 19.1.1 The defined preprocessor operator shall be used appropriately

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Amplification
The only two forms for the `defined` preprocessor operator that are permitted by the C++ Standard
are:

```cpp
defined ( identifier )
defined identifier
```

Generation of the token `defined` during expansion of a macro within a `#if` or `#elif` preprocessing
directive is not permitted.

## Rationale
Violation of this rule results in *undefined behaviour*.

## Example
```cpp
#if defined 1 // Non-compliant - 1 is not an
 // identifier

#define FEATURE(x) defined(x) && ( x != 0 )

#if FEATURE(X) // Non-compliant - defined resulting
 // from expansion

#if defined(x) && ( x != 0 ) // Compliant
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
