# Rule 19.2.3 The ' or " or \ characters and the /* or // character sequences shall not occur in a header file name

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Rationale
Use of the following are *conditionally-supported* with *implementation-defined behaviour*:
*   The `'` or `"` or `\` characters, and the `/*` or `//` character sequences are used between `<` and `>`
delimiters in a *header file* name preprocessing token;
*   The `'` or `\` characters, or the `/*` or `//` character sequences are used between the `"` delimiters
in a *header file* name preprocessing token.

*Note:* even on systems where `\` is the path separator, most implementations will accept the `/` character
as an alternative.

## Example
```cpp
#include "file.h" // Compliant
#include "fi'le.h" // Non-compliant
#include "path\file" // Non-compliant
#include "path\\file" // Non-compliant
#include "path/file" // Compliant
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
