# Rule 21.10.3 The facilities provided by the standard header file <csignal> shall not be used

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Amplification
None of the facilities that are specified as being provided by `<csignal>` shall be used.

*Note:* this rule also applies to the facilities provided by `<signal.h>`.

## Rationale
The inappropriate use of signal handling can lead to *undefined* and *implementation-defined behaviour*.

*Note:* the C++ Standard states that signal handling behaviour is specified in the related version of
ISO 9899 [6].

## Exception
Calls to `signal` with a value of `SIG_IGN` as the second (`func`) parameter may be used to disable one
or more signals. For example:

```cpp
signal( SIGTERM, SIG_IGN );
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
