# Rule 4.1.2 Deprecated features should not be used

## Category
Advisory

## Analysis
Decidable, Single Translation Unit

## Amplification
Deprecated features are those identified in Annex D of the C++ Standard, excluding those in
[depr.c.headers].

## Rationale
Features are deprecated by the C++ Standard when they are superseded by safer or better
alternatives, or are considered to exhibit undesirable behaviour. Features deprecated by a particular
version of the C++ Standard may be withdrawn in a later version.

For example:
*   The `<codecvt>` header was deprecated in C++17; and
*   The *noexcept-specifier* `throw` was deprecated in C++17 (and removed in C++20).

Note: use of the C versions of the C++ Standard Library headers ([depr.c.headers]) is not prohibited
as these headers provide features that are equivalent to the ones in the C++ versions.

## Example
```cpp
#include <codecvt> // Non-compliant - [depr.locale.stdcvt]

void foo() throw() // Non-compliant - [depr.except.spec]
{
}

// In the following example, the generation of the copy constructor of C1 is deprecated when the
// destructor is user-declared:

struct C1
{
  ~C1() = default;
};

C1 c1a {}; // Compliant - no use of copy constructor
C1 c1b { c1a }; // Non-compliant - [depr.impldec]
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
