# Rule 5.0.1 Trigraph-like sequences should not be used

## Category
Advisory

## Analysis
Decidable, Single Translation Unit

## Amplification
*Trigraph-like sequences* occur when the following character sequences appear in the source code:
`??= ??/ ??' ??( ??) ??! ??< ??> ??-`

## Rationale
Trigraphs were removed from the language in C++17. However, to prevent possible confusion, the
sequences should not be used as it is unclear whether their replacement is expected.

## Example
```cpp
const char * msg = "(Date format is ??-??-??)"; // Non-compliant
const char * msg = "(Date format is ?\?-?\?-?\?)"; // Compliant
```

## See also
Rule 4.1.2

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
