# Rule 8.3.2 The built-in unary `+` operator should not be used

## Category
Advisory

## Analysis
Decidable, Single Translation Unit

## Rationale
The built-in unary `+` operator triggers *integral promotion*, but otherwise performs no other operation.
When its operand is a function name or lambda, decay to a function pointer is triggered. The use of
`static_cast` is recommended instead as it makes it clear that these conversions are present.

## Example
```cpp
auto x = + u8a; // Non-compliant - triggers promotion to int
auto pf = +[](){}; // Non-compliant - pf is a void(*)()

x = +1; // Non-compliant
x =+ 1; // Non-compliant - unary +, not +=

enum A : uint8_t { one };
enum B : uint8_t { two };

uint8_t operator+( B b ) { return b; }

auto a = +one; // Non-compliant
auto b = +two; // Rule does not apply
auto c = operator+( two ); // Rule does not apply
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
