Ensures that lifecycle methods are used in a correct context

- Type: problem

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```ts
@Component()
class Test {
  ngDoBootstrap() {}
  ~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive()
class Test {
  ngDoBootstrap() {}
  ~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Injectable()
class Test {
  ngAfterContentChecked() { console.log('AfterContentChecked'); }
  ~~~~~~~~~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Injectable()
class Test {
  ngAfterContentInit() { console.log('ngAfterContentInit'); }
  ~~~~~~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Injectable()
class Test {
  ngAfterViewInit() { console.log('ngAfterViewInit'); }
  ~~~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Injectable()
class Test {
  ngDoBootstrap() {}
  ~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Injectable()
class Test {
  ngDoCheck() { console.log('ngDoCheck'); }
  ~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Injectable()
class Test {
  ngOnChanges() { console.log('ngOnChanges'); }
  ~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Injectable()
class Test {
  ngOnInit() { console.log('ngOnInit'); }
  ~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@NgModule()
class Test {
  ngAfterContentChecked() { console.log('ngAfterContentChecked'); }
  ~~~~~~~~~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@NgModule()
class Test {
  ngAfterContentInit() { console.log('ngAfterContentInit'); }
  ~~~~~~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@NgModule()
class Test {
  ngAfterViewChecked() { console.log('ngAfterViewChecked'); }
  ~~~~~~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@NgModule()
class Test {
  ngAfterViewInit() { console.log('ngAfterViewInit'); }
  ~~~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@NgModule()
class Test {
  ngDoCheck() { console.log('ngDoCheck'); }
  ~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@NgModule()
class Test {
  ngOnChanges() { console.log('ngOnChanges'); }
  ~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@NgModule()
class Test {
  ngOnInit() { console.log('ngOnInit'); }
  ~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@NgModule()
class Test {
  ngOnDestroy() { console.log('ngOnDestroy'); }
  ~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Pipe()
class Test {
  ngAfterContentChecked() { console.log('ngAfterContentChecked'); }
  ~~~~~~~~~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Pipe()
class Test {
  ngAfterContentInit() { console.log('ngAfterContentInit'); }
  ~~~~~~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Pipe()
class Test {
  ngAfterViewChecked() { console.log('ngAfterViewChecked'); }
  ~~~~~~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Pipe()
class Test {
  ngAfterViewInit() { console.log('ngAfterViewInit'); }
  ~~~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Pipe()
class Test {
  ngDoBootstrap() {}
  ~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Pipe()
class Test {
  ngDoCheck() { console.log('ngDoCheck'); }
  ~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Pipe()
class Test {
  ngOnChanges() { console.log('ngOnChanges'); }
  ~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Pipe()
class Test {
  ngOnInit() { console.log('ngOnInit'); }
  ~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Pipe()
class Test implements DoCheck {
  constructor() {}

  ngDoCheck() {}
  ~~~~~~~~~
}

@Directive()
class TestDirective implements OnInit {
  ngOnInit() {
    console.log('Initialized');
  }
}
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```ts
@Injectable()
class Test {
  ngOnDestroy() { console.log('OnDestroy'); }
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component()
class Test {
  ngAfterContentChecked() { console.log('AfterContentChecked'); }
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component()
class Test {
  ngAfterContentInit() { console.log('AfterContentInit'); }
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component()
class Test {
  ngAfterViewChecked() { console.log('AfterViewChecked'); }
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component()
class Test {
  ngAfterViewInit() { console.log('AfterViewInit'); }
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component()
class Test {
  ngDoCheck() { console.log('DoCheck'); }
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component()
class Test {
  ngOnChanges() { console.log('OnChanges'); }
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component()
class Test {
  ngOnDestroy() { console.log('OnDestroy'); }
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component()
class Test {
  ngOnInit() { console.log('OnInit'); }
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive()
class Test {
  ngAfterContentChecked() { console.log('AfterContentChecked'); }
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive()
class Test {
  ngAfterContentInit() { console.log('AfterContentInit'); }
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive()
class Test {
  ngAfterViewChecked() { console.log('AfterViewChecked'); }
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive()
class Test {
  ngAfterViewInit() { console.log('AfterViewInit'); }
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive()
class Test {
  ngDoCheck() { console.log('DoCheck'); }
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive()
class Test {
  ngOnChanges() { console.log('OnChanges'); }
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive()
class Test {
  ngOnDestroy() { console.log('OnDestroy'); }
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive()
class Test {
  ngOnInit() { console.log('OnInit'); }
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Injectable()
class Test {
  ngOnDestroy() { console.log('OnDestroy'); }
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@NgModule()
class Test {
  ngDoBootstrap() {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Pipe()
class Test {
  ngOnDestroy() { console.log('OnDestroy'); }
}
```

</details>
