Ensures that directives not implement conflicting lifecycle interfaces.

- Type: suggestion

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```ts
class Test implements DoCheck, OnChanges, run {
                      ~~~~~~~  ~~~~~~~~~
  test() {}
  test1() {}
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
class Test implements DoCheck, OnChanges {
                      ~~~~~~~  ~~~~~~~~~
  ngDoCheck() {}
  ~~~~~~~~~~~~~~
  ngOnChanges() {}
  ~~~~~~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
class Test {
  ngDoCheck() {}
  ~~~~~~~~~~~~~~
  ngOnChanges() {}
  ~~~~~~~~~~~~~~~~
}
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```ts
class Test implements DoCheck {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
class Test {
  ngDoCheck() {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
class Test implements DoCheck {
  ngDoCheck() {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
class Test implements OnChanges {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
class Test {
  ngOnChanges() {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
class Test implements OnChanges {
  ngOnChanges() {}
}
```

</details>
