Disallows usage of the `queries` metadata property. See more at https://angular.io/styleguide#style-05-12.

- Type: suggestion

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```ts
@Component({
  queries: {
  ~~~~~~~~~~
    contentChild: new ContentChild(ChildDirective),
    contentChildren: new ContentChildren(ChildDirective),
    viewChild: new ViewChild(ChildDirective),
    viewChildren: new ViewChildren(ChildDirective)
  },
  ~
  selector: 'app-test'
})
class TestComponent {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive({
  queries: {
  ~~~~~~~~~
    contentChild: new ContentChild(ChildDirective),
    contentChildren: new ContentChildren(ChildDirective),
    viewChild: new ViewChild(ChildDirective),
    viewChildren: new ViewChildren(ChildDirective)
  },
  ~
  selector: 'app-test'
})
class TestDirective {}
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: 'app-test',
  template: 'Hello'
})
class TestComponent {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'app-test'
})
class TestDirective {}
```

</details>
