[Accessibility] Ensures that elements with interactive handlers like `(click)` are focusable.

- Type: suggestion

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```html
<div aria-hidden="false" (click)="onClick()"></div>
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<div [attr.aria-hidden]="false" (click)="onClick()"></div>
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<div role="button" aria-disabled="false" (click)="onClick()"></div>
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<div [attr.aria-disabled]="false" (click)="onClick()"></div>
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<div role="button" (click)="onClick()"></div>
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<span (click)="onClick()">Submit</span>
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<div (click)="onClick()" [attr.aria-label]="clickableThing"></div>
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<div (click)="onClick()" role="invalid"></div>
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<area (click)="onClick()" class="foo">
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<a (click)="onClick()">Click me</a>
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<div (keyup)="onKeyUp()" (keydown)="onKeyDown()" (keypress)="onKeyPress()">Cannot be focused</div>
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<div [attr.contenteditable]="false" (keyup)="onKeyUp()">Cannot be focused</div>
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```html
<div></div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div aria-hidden (click)="onClick()"></div>
<div aria-hidden="true" (click)="onClick()"></div>
<div [attr.aria-hidden]="true" (click)="onClick()"></div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div role="button" aria-disabled="true" (click)="onClick()"></div>
<div role="button" [attr.aria-disabled]="true" (click)="onClick()"></div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div role="presentation" (click)="onClick()"></div>
<div role="none" (click)="onClick()"></div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div role="progressbar" (click)="onClick()"></div>
<div role="region" (click)="onClick()"></div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<input type="hidden" (click)="onClick()">
<input type="hidden" (click)="onClick()" tabindex="-1">
<input type="hidden" (click)="onClick()" [attr.tabindex]="-1">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<input type="text" (keyup)="onKeyUp()">
<input (keydown)="onKeydown()">
<input (click)="onClick()" role="combobox">
<button (click)="onClick()" class="foo">Foo</button>
<option (click)="onClick()" class="foo">Food</option>
<select (click)="onClick()" class="foo"></select>
<summary (click)="onClick()">Foo</summary>
<textarea (keypress)="onKeypress()" class="foo"></textarea>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<input disabled type="text" (click)="onClick()">
<button disabled (click)="onClick()" class="foo">Foo</button>
<select disabled (click)="onClick()" class="foo"></select>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<area href="#" (click)="onClick()" class="foo"/>
<area (click)="onClick()" tabindex=0 class="foo"/>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<a (click)="onClick()" tabindex="0">Click me</a>
<a (click)="onClick()" [attr.tabindex]="0">Click me</a>',
<a (click)="onClick()" tabindex="bad">Click me</a>',
<a (click)="onClick()" [attr.tabindex]="undefined"}>Click me</a>',
<a (click)="onClick()" [attr.tabindex]="dynamicTabindex">Click me</a>',
```

<br>

---

<br>

#### ✅ Valid Code

```html
<a role="button" (click)="onClick()" href="#">hash</a>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<a (click)="onClick()" href="http://x.y.z">x.y.z</a>
<a role="link" (click)="onClick()" href="http://x.y.z">x.y.z</a>
<a (click)="onClick()" href="javascript:void(0);">Click ALL the things!</a>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<a (click)="onClick()" tabindex="0">x.y.z</a>
<a (click)="onClick()" tabindex={0}>x.y.z</a>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<a routerLink="route" (click)="onClick()"></a>
<a [routerLink]="route" (click)="onClick()"></a>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div (click)="onClick()" tabindex="invalid"></div>
<div (click)="onClick()" [attr.tabindex]="undefined"></div>
<span (click)="onClick()" [attr.tabindex]=="false">Submit</span>
<span (click)="onClick()" [attr.tabindex]=="null">Submit</span>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<span (click)="onClick()" tabindex="0">Click me!</span>
<span (click)="onClick()" [attr.tabindex]="0">Click me!</span>
<span (click)="onClick()" tabindex="-1">Click me!</span>
<span (click)="onClick()" [attr.tabindex]="-1">Click me!</span>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div role="button" tabindex="0" (click)="onClick()"></div>
<div role="checkbox" tabindex="0" (click)="onClick()"></div>
<div role="link" tabindex="0" (click)="onClick()"></div>
<div role="menuitem" tabindex="0" (click)="onClick()"></div>
<div role="checkbox" tabindex="0" (click)="onClick()"></div>
<div role="menuitem" tabindex="0" (click)="onClick()"></div>
<div role="option" tabindex="0" (click)="onClick()"></div>
<div role="radio" tabindex="0" (click)="onClick()"></div>
<div role="spinbutton" tabindex="0" (click)="onClick()"></div>
<div role="switch" tabindex="0" (click)="onClick()"></div>
<div role="tablist" tabindex="0" (click)="onClick()"></div>
<div role="tab" tabindex="0" (click)="onClick()"></div>
<div role="textbox" tabindex="0" (click)="onClick()"></div>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<div contenteditable="true" (keyup)="onKeyUp()">Edit this text</div>
<div [attr.contenteditable]="true" (keydown)="onKeyDown()">Edit this text</div>
<div contenteditable (keypress)="onKeyPress()">Edit this too!</div>
```

</details>
