[Accessibility] Ensures elements with ARIA roles have all required properties for that role.

- Type: suggestion

- 💡 Provides suggestions on how to fix issues (https://eslint.org/docs/developer-guide/working-with-rules#providing-suggestions)

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```html
<div role="combobox"></div>
     ~~~~~~~~~~~~~~~
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```html
<span role="checkbox" aria-checked="false"></span>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<input type="checkbox" role="switch">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<span role="heading" aria-level="5"></span>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<span role="button"></span>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<app-component [role]="ADMIN"></app-component>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<summary (click)="onClick()">Foo</summary>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<summary (click)="onClick()" aria-expanded="false">Bar</summary>
```

</details>
