Component selector must be declared

- Type: suggestion

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```ts
@Component()
~~~~~~~~~~~~
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component()
~~~~~~~~~~~~
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
~~~~~~~~~~~~
  selector: ''
})
~~
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
~~~~~~~~~~~~
  selector: 0
})
~~
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
~~~~~~~~~~~~
  selector: null
})
~~
class Test {}
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: 'sg-bar-foo'
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: "sg-bar-foo"
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: `sg-bar-foo`
})
class Test {}
```

</details>
