Ensures that classes implement lifecycle interfaces corresponding to the declared lifecycle methods. See more at https://angular.io/styleguide#style-09-01

- Type: suggestion

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```ts
@Component()
class Test {
  ngOnInit() {
  ~~~~~~~~
  }
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive()
class Test extends Component implements OnInit {
  ngOnInit() {}

  ngOnDestroy() {
  ~~~~~~~~~~~
  }
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Injectable()
class Test {
  ngDoBootstrap() {}
  ~~~~~~~~~~~~~

  ngOnInit() {}
  ~~~~~~~~

  ngOnDestroy() {}
  ~~~~~~~~~~~
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@NgModule()
class Test extends Component implements ng.OnInit {
  ngOnInit() {}

  ngOnDestroy() {
  ~~~~~~~~~~~
  }
}
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```ts
class Test implements OnInit {
  ngOnInit() {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
class Test implements DoBootstrap {
      ngDoBootstrap() {}
    }
```

<br>

---

<br>

#### ✅ Valid Code

```ts
class Test extends Component implements OnInit, OnDestroy  {
  ngOnInit() {}

  private ngOnChanges = '';

  ngOnDestroy() {}

  ngOnSmth() {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
class Test extends Component implements ng.OnInit, ng.OnDestroy  {
  ngOnInit() {}

  private ngOnChanges = '';

  ngOnDestroy() {}

  ngOnSmth() {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
class Test {}
```

</details>
