Ensures that `Pipes` implement `PipeTransform` interface

- Type: suggestion
- 🔧 Supports autofix (`--fix`)

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```ts
@Pipe({ name: 'test' })
class Test {
      ~~~~
  transform(value: string) {}
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
import { HttpClient } from '@angular/common/http';
import type { PipeTransform } from '@angular/core';
import { Component,
  Pipe,
  Directive } from '@angular/core';

@Pipe({ name: 'test' })
class Test implements AnInterface {
      ~~~~
  transform(value: string) {}
}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
import type { OnInit } from '@angular/core';

@OtherDecorator() @Pipe({ name: 'test' })
class Test implements AnInterface, AnotherInterface {
      ~~~~
  transform(value: string) {}
}
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```ts
@Component({ template: 'test' })
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Pipe({ name: 'test' })
class Test implements PipeTransform {
  transform(value: string) {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@OtherDecorator() @Pipe({ name: 'test' })
class Test implements PipeTransform {
  transform(value: string) {}
}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Pipe({ name: 'test' })
class Test implements ng.PipeTransform {
  transform(value: string) {}
}
```

</details>
