Disallow missing displayName in a React component definition.




DisplayName allows you to name your component. This name is used by React in debugging messages.

## Rule Details

Examples of **incorrect** code for this rule:

```jsx
var Hello = createReactClass({
  render: function() {
    return <div>Hello {this.props.name}</div>;
  }
});

const Hello = React.memo(({ a }) => {
  return <>{a}</>
})

export default ({ a }) => {
  return <>{a}</>
}
```

Examples of **correct** code for this rule:

```jsx
var Hello = createReactClass({
  displayName: 'Hello',
  render: function() {
    return <div>Hello {this.props.name}</div>;
  }
});

const Hello = React.memo(function Hello({ a }) {
  return <>{a}</>
})
```

## About component detection

For this rule to work we need to detect React components, this could be very hard since components could be declared in a lot of ways.

For now we should detect components created with:

- `createReactClass()`
- an ES6 class that inherit from `React.Component` or `Component`
- a stateless function that return JSX or the result of a `React.createElement` call.
