Disallow file extensions that may contain JSX.


## Rule Details

Examples of **incorrect** code for this rule:

```jsx
// filename: MyComponent.js
function MyComponent() {
  return <div />;
}
```

Examples of **correct** code for this rule:

```jsx
// filename: MyComponent.jsx
function MyComponent() {
  return <div />;
}
```

Beware this rule **only** reports JSX syntax, **not** other non-standard syntax such as experimental features or type annotations.

## When Not To Use It

If you don't care about restricting the file extensions that may contain JSX.
