Disallow usage of string literals in JSX.


There are a few scenarios where you want to avoid string literals in JSX. You may want to enforce consistency, reduce syntax highlighting issues, or ensure that strings are part of a translation system.

## Rule Details

By default this rule requires that you wrap all literal strings in a JSX container `{'TEXT'}`.

Examples of **incorrect** code for this rule:

```jsx
var Hello = <div>test</div>;
```

Examples of **correct** code for this rule:

```jsx
var Hello = <div>{'test'}</div>;
```

```jsx
var Hello = <div>
  {'test'}
</div>;
```

## When Not To Use It

If you do not want to enforce any style JSX literals, then you can disable this rule.
