Disallow multiple component definition per file.


Declaring only one component per file improves readability and reusability of components.

## Rule Details

Examples of **incorrect** code for this rule:

```jsx
var Hello = createReactClass({
  render: function() {
    return <div>Hello {this.props.name}</div>;
  }
});

var HelloJohn = createReactClass({
  render: function() {
    return <Hello name="John" />;
  }
});
```

Examples of **correct** code for this rule:

```jsx
var Hello = require('./components/Hello');

var HelloJohn = createReactClass({
  render: function() {
    return <Hello name="John" />;
  }
});
```

## When Not To Use It

If you prefer to declare multiple components per file you can disable this rule.
