Empty static blocks, while not technically errors, usually occur due to refactoring that wasn't completed. They can cause confusion when reading code.

## Rule Details

This rule disallows empty static blocks. This rule ignores static blocks which contain a comment.

Examples of **incorrect** code for this rule:

```js
/*eslint no-empty-static-block: "error"*/

class Foo {
    static {}
}
```

Examples of **correct** code for this rule:

```js
/*eslint no-empty-static-block: "error"*/

class Foo {
    static {
        bar();
    }
}

class Foo {
    static {
        // comment
    }
}
```

## When Not To Use It

This rule should not be used in environments prior to ES2022.

## References

- https://github.com/tc39/proposal-class-static-block
