This rule restricts the use of parentheses to only where they are necessary.

## Rule Details

This rule always ignores extra parentheses around the following:

* RegExp literals such as `(/abc/).test(var)` to avoid conflicts with the [wrap-regex](https://eslint.org/docs/rules/wrap-regex) rule
* immediately-invoked function expressions (also known as IIFEs) such as `var x = (function () {})();` and `var x = (function () {}());` to avoid conflicts with the [wrap-iife](https://eslint.org/docs/rules/wrap-iife) rule
* arrow function arguments to avoid conflicts with the [arrow-parens](https://eslint.org/docs/rules/arrow-parens) rule

## References

- https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Operator_Precedence
