This rule can help you locate potential ReferenceErrors resulting from misspellings of variable and parameter names, or accidental implicit globals (for example, from forgetting the `var` keyword in a `for` loop initializer).

## Rule Details

Any reference to an undeclared variable causes a warning, unless the variable is explicitly mentioned in a `/*global ...*/` comment, or specified in the [`globals` key in the configuration file](https://eslint.org/docs/use/configure/language-options#using-configuration-files-1). A common use case for these is if you intentionally use globals that are defined elsewhere (e.g. in a script sourced from HTML).

Examples of **incorrect** code for this rule:

```js
/*eslint no-undef: "error"*/

var foo = someFunction();
var bar = a + 1;
```

Examples of **correct** code for this rule with `global` declaration:

```js
/*global someFunction, a*/
/*eslint no-undef: "error"*/

var foo = someFunction();
var bar = a + 1;
```

Note that this rule does not disallow assignments to read-only global variables.
See [no-global-assign](https://eslint.org/docs/rules/no-global-assign) if you also want to disallow those assignments.

This rule also does not disallow redeclarations of global variables.
See [no-redeclare](https://eslint.org/docs/rules/no-redeclare) if you also want to disallow those redeclarations.

## Environments

For convenience, ESLint provides shortcuts that pre-define global variables exposed by popular libraries and runtime environments. This rule supports these environments, as listed in [Specifying Environments](https://eslint.org/docs/use/configure/language-options#specifying-environments).  A few examples are given below.

### browser

Examples of **correct** code for this rule with `browser` environment:

```js
/*eslint no-undef: "error"*/
/*eslint-env browser*/

setTimeout(function() {
    alert("Hello");
});
```

### Node.js

Examples of **correct** code for this rule with `node` environment:

```js
/*eslint no-undef: "error"*/
/*eslint-env node*/

var fs = require("fs");
module.exports = function() {
    console.log(fs);
};
```

## When Not To Use It

If explicit declaration of global variables is not to your taste.

## Compatibility

This rule provides compatibility with treatment of global variables in [JSHint](http://jshint.com/) and [JSLint](http://www.jslint.com).
